---
Difficulty: Hard  
Source: Daily-Question(POTD 29-Nov)  
tags:
    - Breadth-First Search
    - Graph
    - Array
    - Matrix
    - Shortest Path
    - Heap (Priority Queue)
---

# 🚀 *2577 - Minimum Time to Visit a Cell In a Grid* 🧠

### Problem Link:
[**LeetCode - Minimum Time to Visit a Cell In a Grid**](https://leetcode.com/problems/minimum-time-to-visit-a-cell-in-a-grid/description/?envType=daily-question&envId=2024-11-29)

## 💡 **Problem Breakdown:**

You are given an `m x n` matrix grid consisting of non-negative integers where `grid[row][col]` represents the minimum time required to be able to visit the cell `(row, col)`, meaning you can only visit the cell `(row, col)` when the time you visit it is greater than or equal to `grid[row][col]`.

You start at the top-left cell of the matrix at time `t = 0` and need to reach the bottom-right cell. You can move to any adjacent cell in the four directions: up, down, left, and right. Each move takes exactly 1 second.

Return the minimum time required to reach the bottom-right cell of the matrix, or return `-1` if it’s impossible to reach that cell.

## 🔍 **Example Walkthrough:**

### Example 1:

<img src="https://github.com/user-attachments/assets/6aeb26ec-f2e6-4fbb-99a6-ebc2b8805198" width="38%">

**Input:**  
`grid = [[0,1,3,2], [5,1,2,5], [4,3,8,6]]`  
**Output:**  
`7`

**Explanation:**  
One possible path to reach the bottom-right cell at time `t = 7` is:
- At t = 0: Start at `(0, 0)`.
- At t = 1: Move to `(0, 1)`. It’s possible because `grid[0][1] ≤ 1`.
- At t = 2: Move to `(1, 1)`. It’s possible because `grid[1][1] ≤ 2`.
- At t = 3: Move to `(1, 2)`. It’s possible because `grid[1][2] ≤ 3`.
- At t = 4: Move to `(1, 1)`. It’s possible because `grid[1][1] ≤ 4`.
- At t = 5: Move to `(1, 2)`. It’s possible because `grid[1][2] ≤ 5`.
- At t = 6: Move to `(1, 3)`. It’s possible because `grid[1][3] ≤ 6`.
- At t = 7: Move to `(2, 3)`. It’s possible because `grid[2][3] ≤ 7`.

### Example 2:

<img src="https://github.com/user-attachments/assets/eb8a4535-cc96-4bb7-832a-0490e107e4f5" width="28%">

**Input:**  
`grid = [[0,2,4], [3,2,1], [1,0,4]]`  
**Output:**  
`-1`

**Explanation:**  
There is no valid path from the top-left to the bottom-right cell, so the output is `-1`.

### Constraints:

- $`m == grid.length`$
- $`n == grid[0].length`$
- $`2 ≤ m, n ≤ 1000`$
- $`4 ≤ m * n ≤ 10^5`$
- $`0 ≤ grid[i][j] ≤ 10^5`$
- $`grid[0][0] == 0`$

## 🎯 **My Approach:**

This problem can be treated as a pathfinding problem on a grid, and we can use a **priority queue (min-heap)** for efficient traversal. The main idea is to:

1. **BFS with Priority Queue**: 
   - Each cell has a minimum time constraint, and our goal is to always process the least time-consuming path first.
   - We start from `(0, 0)` and push the current time and position to the priority queue.
   - As we process each cell, we attempt to move to adjacent cells, and the next time is calculated based on both the current time and the minimum time constraint of the adjacent cell.
   
2. **Priority Queue**: 
   - The priority queue allows us to always pick the next cell to visit that has the minimum possible time, ensuring we explore the least expensive path first.
   - The traversal continues until we reach the bottom-right corner or determine it's impossible to reach it.

## 🕒 **Time Complexity:**
- **O(m × n log(m × n))**:  
  The time complexity is dominated by the operations on the priority queue, which can store at most `m × n` nodes. Each insertion and extraction from the priority queue takes `O(log(m × n))`.

- **Space Complexity:**  
  **O(m × n)**: The space is used by the priority queue and visited array to store the grid positions.

## 📝 **Solution Code**

## Code (C)

```c
typedef struct {
    int time, row, col;
} Node;

typedef struct {
    Node* data;
    int size, capacity;
} PriorityQueue;

PriorityQueue* createPriorityQueue(int capacity) {
    PriorityQueue* pq = (PriorityQueue*)malloc(sizeof(PriorityQueue));
    pq->data = (Node*)malloc(capacity * sizeof(Node));
    pq->size = 0;
    pq->capacity = capacity;
    return pq;
}

void swap(Node* a, Node* b) {
    Node temp = *a;
    *a = *b;
    *b = temp;
}

void push(PriorityQueue* pq, Node node) {
    if (pq->size == pq->capacity) return;
    pq->data[pq->size] = node;
    int i = pq->size++;
    while (i > 0) {
        int parent = (i - 1) / 2;
        if (pq->data[parent].time <= pq->data[i].time) break;
        swap(&pq->data[parent], &pq->data[i]);
        i = parent;
    }
}

Node pop(PriorityQueue* pq) {
    Node top = pq->data[0];
    pq->data[0] = pq->data[--pq->size];
    int i = 0;
    while (true) {
        int left = 2 * i + 1, right = 2 * i + 2, smallest = i;
        if (left < pq->size && pq->data[left].time < pq->data[smallest].time) smallest = left;
        if (right < pq->size && pq->data[right].time < pq->data[smallest].time) smallest = right;
        if (smallest == i) break;
        swap(&pq->data[i], &pq->data[smallest]);
        i = smallest;
    }
    return top;
}

bool isEmpty(PriorityQueue* pq) {
    return pq->size == 0;
}

int minimumTime(int** grid, int gridSize, int* gridColSize) {
    int rows = gridSize, cols = gridColSize[0];
    if (grid[0][1] > 1 && grid[1][0] > 1) return -1;

    int dirs[4][2] = {{-1, 0}, {0, 1}, {1, 0}, {0, -1}};
    bool** seen = (bool**)malloc(rows * sizeof(bool*));
    for (int i = 0; i < rows; i++) {
        seen[i] = (bool*)calloc(cols, sizeof(bool));
    }

    PriorityQueue* pq = createPriorityQueue(rows * cols);
    push(pq, (Node){0, 0, 0});
    seen[0][0] = true;

    while (!isEmpty(pq)) {
        Node current = pop(pq);
        int time = current.time, row = current.row, col = current.col;

        for (int d = 0; d < 4; d++) {
            int newRow = row + dirs[d][0], newCol = col + dirs[d][1];
            if (newRow >= 0 && newRow < rows && newCol >= 0 && newCol < cols && !seen[newRow][newCol]) {
                int newTime = time + 1;
                if (grid[newRow][newCol] > newTime) {
                    newTime += (grid[newRow][newCol] - newTime + 1) / 2 * 2;
                }
                if (newRow == rows - 1 && newCol == cols - 1) {
                    for (int i = 0; i < rows; i++) free(seen[i]);
                    free(seen);
                    free(pq->data);
                    free(pq);
                    return newTime;
                }
                seen[newRow][newCol] = true;
                push(pq, (Node){newTime, newRow, newCol});
            }
        }
    }

    for (int i = 0; i < rows; i++) free(seen[i]);
    free(seen);
    free(pq->data);
    free(pq);

    return -1;
}
```

## Code (C++)

```cpp
class Solution {
public:
    int minimumTime(vector<vector<int>>& grid) {
        int rows = grid.size(), cols = grid[0].size();
        if (grid[0][1] > 1 && grid[1][0] > 1) return -1;

        vector<vector<bool>> visited(rows, vector<bool>(cols, false));
        vector<pair<int, int>> directions = {{-1, 0}, {1, 0}, {0, -1}, {0, 1}};

        priority_queue<tuple<int, int, int>, vector<tuple<int, int, int>>, greater<>> pq;
        pq.emplace(0, 0, 0);
        visited[0][0] = true;

        while (!pq.empty()) {
            auto [time, row, col] = pq.top();
            pq.pop();

            for (auto [dr, dc] : directions) {
                int newRow = row + dr, newCol = col + dc;
                if (newRow >= 0 && newRow < rows && newCol >= 0 && newCol < cols && !visited[newRow][newCol]) {
                    int newTime = time + 1;
                    if (grid[newRow][newCol] > newTime)
                        newTime += (grid[newRow][newCol] - newTime + 1) / 2 * 2;

                    if (newRow == rows - 1 && newCol == cols - 1)
                        return newTime;

                    visited[newRow][newCol] = true;
                    pq.emplace(newTime, newRow, newCol);
                }
            }
        }

        return -1;
    }
};
```

## Code (Java)

```java
class Solution {
    public int minimumTime(int[][] grid) {
        int rows = grid.length, cols = grid[0].length;
        if (grid[0][1] > 1 && grid[1][0] > 1) return -1;

        boolean[][] visited = new boolean[rows][cols];
        PriorityQueue<int[]> pq = new PriorityQueue<>((a, b) -> Integer.compare(a[0], b[0]));
        pq.offer(new int[]{0, 0, 0});
        visited[0][0] = true;

        int[][] directions = {{-1, 0}, {1, 0}, {0, -1}, {0, 1}};

        while (!pq.isEmpty()) {
            int[] curr = pq.poll();
            int time = curr[0], row = curr[1], col = curr[2];

            for (int[] dir : directions) {
                int newRow = row + dir[0], newCol = col + dir[1];
                if (newRow >= 0 && newRow < rows && newCol >= 0 && newCol < cols && !visited[newRow][newCol]) {
                    int newTime = time + 1;
                    if (grid[newRow][newCol] > newTime)
                        newTime += (grid[newRow][newCol] - newTime + 1) / 2 * 2;

                    if (newRow == rows - 1 && newCol == cols - 1)
                        return newTime;

                    visited[newRow][newCol] = true;
                    pq.offer(new int[]{newTime, newRow, newCol});
                }
            }
        }

        return -1;
    }
}
```

## Code (Python)

```python3
from heapq import heappush, heappop
from typing import List

class Solution:
    def minimumTime(self, grid: List[List[int]]) -> int:
        MOVES = [(-1, 0), (0, 1), (1, 0), (0, -1)]
        if grid[0][1] > 1 and grid[1][0] > 1:
            return -1
        rows, cols = len(grid), len(grid[0])
        pq = [(0, 0, 0)]
        seen = [[False] * cols for _ in range(rows)]
        seen[0][0] = True
        while pq:
            time, row, col = heappop(pq)
            for dr, dc in MOVES:
                newRow, newCol = row + dr, col + dc
                if 0 <= newRow < rows and 0 <= newCol < cols and not seen[newRow][newCol]:
                    newTime = time + 1
                    if grid[newRow][newCol] > newTime:
                        newTime += (grid[newRow][newCol] - newTime + 1) // 2 * 2
                    if newRow == rows - 1 and newCol == cols - 1:
                        return newTime
                    seen[newRow][newCol] = True
                    heappush(pq, (newTime, newRow, newCol))
        return -1
```

## Code (Rust)

```rust
use std::collections::BinaryHeap;
use std::cmp::Reverse;

impl Solution {
    pub fn minimum_time(grid: Vec<Vec<i32>>) -> i32 {
        let directions = [(-1, 0), (1, 0), (0, -1), (0, 1)];
        let rows = grid.len();
        let cols = grid[0].len();

        if grid[0][1] > 1 && grid[1][0] > 1 {
            return -1;
        }

        let mut visited = vec![vec![false; cols]; rows];
        let mut heap = BinaryHeap::new();
        heap.push(Reverse((0, 0, 0))); 
        visited[0][0] = true;

        while let Some(Reverse((time, row, col))) = heap.pop() {
            for &(dr, dc) in &directions {
                let new_row = row as isize + dr;
                let new_col = col as isize + dc;

                if new_row >= 0
                    && new_row < rows as isize
                    && new_col >= 0
                    && new_col < cols as isize
                    && !visited[new_row as usize][new_col as usize]
                {
                    let mut new_time = time + 1;
                    let (nr, nc) = (new_row as usize, new_col as usize);
                    if grid[nr][nc] > new_time {
                        new_time += (grid[nr][nc] - new_time + 1) / 2 * 2;
                    }

                    if nr == rows - 1 && nc == cols - 1 {
                        return new_time;
                    }

                    visited[nr][nc] = true;
                    heap.push(Reverse((new_time, nr, nc)));
                }
            }
        }

        -1
    }
}
```


# 🎯 **Contribute or Ask Questions:**
For more discussions, questions, or help with the solution, feel free to reach out on LinkedIn: [**Connect with Me!**](https://www.linkedin.com/in/het-patel-8b110525a/).

## <img src="https://github.com/user-attachments/assets/35f6838c-52f5-4e48-8a98-c5203f8c57e3" style="width:29px; color: #FFD700" alt="Star GIF"> **Enjoying the Solution?**  
If this helped you, please **star this repo** to support the efforts and keep it growing!
